//
//  Logging.h
//  dJAX
//
//  Copyright 2011 dJAX, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Constants.h"

extern NSString * const kMPClearErrorLogFormatWithAdUnitID;
extern NSString * const kMPWarmingUpErrorLogFormatWithAdUnitID;

// Lower = finer-grained logs.
typedef enum
{
    dJAXLogLevelAll        = 0,
    dJAXLogLevelTrace        = 10,
    dJAXLogLevelDebug        = 20,
    dJAXLogLevelInfo        = 30,
    dJAXLogLevelWarn        = 40,
    dJAXLogLevelError        = 50,
    dJAXLogLevelFatal        = 60,
    dJAXLogLevelOff        = 70
} dJAXLogLevel;

dJAXLogLevel MPLogGetLevel(void);
void MPLogSetLevel(dJAXLogLevel level);
void _MPLogTrace(NSString *format, ...);
void _MPLogDebug(NSString *format, ...);
void _MPLogInfo(NSString *format, ...);
void _MPLogWarn(NSString *format, ...);
void _MPLogError(NSString *format, ...);
void _MPLogFatal(NSString *format, ...);

#if dJAX_DEBUG_MODE && !SPECS

#define MPLogTrace(...) _MPLogTrace(__VA_ARGS__)
#define MPLogDebug(...) _MPLogDebug(__VA_ARGS__)
#define MPLogInfo(...) _MPLogInfo(__VA_ARGS__)
#define MPLogWarn(...) _MPLogWarn(__VA_ARGS__)
#define MPLogError(...) _MPLogError(__VA_ARGS__)
#define MPLogFatal(...) _MPLogFatal(__VA_ARGS__)

#else

#define MPLogTrace(...) {}
#define MPLogDebug(...) {}
#define MPLogInfo(...) {}
#define MPLogWarn(...) {}
#define MPLogError(...) {}
#define MPLogFatal(...) {}

#endif
